function [b,add]=udpget(skt,name)
%function [b,add]=udpget(skt,name)
% High level function for getting variables from a PIC over udp
% calls udppeek to do its work
% udpset and udpget are the functions expected to be used normally
% updated for octave 4-Feb-2018 - Ian Stothers
% Retry added with exponential backoff - binary length driven
% 19-Dec- 2022 - Ian Stothers
%
% Serial bits added
% 10-June- 2023 - Ian Stothers
if (isfield(skt,'ser')==1)
  [b,add]=serget(skt,name);
else
  add=[];
  b=[];
  hidx=find(skt.hash==sum(name+0));
  if (max(size(hidx))>0)
   idx=findname(skt.name,name,hidx);

   if (idx>0)
      add=skt.ptr(idx);
      b=[];
      retry=5;
      while(retry>0)
       b=udppeek(skt,skt.ptr(idx),skt.len(idx));
       if(size(b)(2)==skt.len(idx))
        retry=-1;
       else
        retry=retry-1;
       end
      end
      b=udpgettconv(b,skt.type(idx),skt.rows(idx));
   else
      error([name ' not found on target at IP '  sprintf('%s',skt.ip) ]);
   end
  else
   error([name ' not found on target at IP '  sprintf('%s',skt.ip) ]);
  end
end
endfunction

function [b,add]=serget(skt,name)
%function [b,add]=serget(skt,name)
% High level function for getting variables from a PIC over udp
% calls udppeek to do its work
% serset and serget are the functions expected to be used normally
% updated for octave 4-Feb-2018 - Ian Stothers
% Retry added with exponential backoff - binary length driven
% 19-Dec- 2022 - Ian Stothers
% 7-Jun- 2023 - Ian Stothers
%
add=[];
b=[];
hidx=find(skt.hash==sum(name+0));
if (max(size(hidx))>0)
   idx=findname(skt.name,name,hidx);

   if (idx>0)
      add=skt.ptr(idx);
      b=[];
      retry=5;
      while(retry>0)
       b=udppeek(skt,skt.ptr(idx),skt.len(idx));
       if(size(b)(2)==skt.len(idx))
        retry=-1;
       else
        retry=retry-1;
       end
      end
      b=udpgettconv(b,skt.type(idx),skt.rows(idx));
   else
      error([name ' not found on target at IP '  sprintf('%s',skt.ip) ]);
   end
else
   error([name ' not found on target at IP '  sprintf('%s',skt.ip) ]);
end
endfunction
